<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('first_name');
			$table->string('last_name');
			$table->string('phone');
			$table->string('email');
			$table->string('password');
			$table->integer('role_id')->unsigned();
			$table->integer('dealer_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}