<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInsurancesTable extends Migration {

	public function up()
	{
		Schema::create('insurances', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('building_type_id')->unsigned();
			$table->decimal('net_cost')->nullable();
			$table->decimal('tax_cost')->nullable();
			$table->datetime('start_date')->nullable();
			$table->datetime('expire_date');
			$table->integer('building_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('insurances');
	}
}