<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSegmentsTable extends Migration {

	public function up()
	{
		Schema::create('segments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('road_id')->unsigned();
			$table->integer('part')->unsigned()->nullable();
			$table->string('source_long', 191)->nullable();
			$table->string('target_long', 191)->nullable();
			$table->string('source_lat', 191)->nullable();
			$table->string('target_lat', 191)->nullable();
			$table->string('length', 10)->nullable();
			$table->string('capacity', 10)->nullable();
			$table->boolean('has_intersection')->nullable()->default(0);
			$table->boolean('intersection_in')->nullable()->default(0);
			$table->boolean('intersection_out')->nullable()->default(0);
		});
	}

	public function down()
	{
		Schema::drop('segments');
	}
}