<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductRatingsTable extends Migration {

	public function up()
	{
		Schema::create('product_ratings', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_id')->unsigned();
			$table->float('rating')->nullable();
			$table->string('title', 255)->nullable();
			$table->text('comment')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('product_ratings');
	}
}