<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePromocodesTable extends Migration {

	public function up()
	{
		Schema::create('promocodes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('discount_code', 20)->nullable();
			$table->string('discount_percentage', 10)->nullable();
			$table->text('description')->nullable();
			$table->string('max_discount', 20)->nullable();
			$table->string('min_discount')->nullable();
			$table->integer('min_order_amount')->nullable();
			$table->integer('total_users')->nullable();
			$table->date('start_date')->nullable();
			$table->date('expire_date')->nullable();
			$table->boolean('is_valid');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('promocodes');
	}
}