<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 255)->nullable();
			$table->string('last_name', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->bigInteger('phone_number')->nullable();
			$table->enum('gender', array('Male', 'Female'))->nullable();
			$table->string('profile_pic', 255)->nullable();
			$table->date('dob')->nullable();
			$table->string('device_token', 255)->nullable();
			$table->string('device_id', 255)->nullable();
			$table->string('os_type', 20)->nullable();
			$table->string('verification_code', 10)->nullable();
			$table->boolean('is_email_verified')->default(0);
			$table->boolean('is_phone_verified')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}