<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Payment extends Eloquent {

	protected $table = 'payments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('transaction_id', 'status');

	public function order()
	{
		return $this->hasOne('Order', 'order_id');
	}

}