<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Products extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'sku', 'short_description', 'long_description', 'price', 'status');

	public function ratings()
	{
		return $this->hasMany('ProductRating', 'product_id');
	}

	public function images()
	{
		return $this->hasMany('ProductImage', 'product_id');
	}

}