<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('first_name', 'last_name', 'email', 'phone_number', 'gender', 'profile_pic', 'dob');

	public function addresses()
	{
		return $this->hasMany('UserAddress', 'user_id');
	}

	public function socialuser()
	{
		return $this->hasMany('UserSocialLogin', 'user_id');
	}

	public function orders()
	{
		return $this->hasMany('Order', 'user_id');
	}

	public function cart()
	{
		return $this->hasMany('Cart', 'user_id');
	}

}