<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('discount_id', 'pre_order_amount', 'tax_amount', 'discount_amount', 'total_amount', 'date', 'status');

    public function promocode()
    {
        return $this->hasOne('Promocode', 'discount_id');
    }

    public function user()
    {
        return $this->hasOne('User', 'user_id');
    }

    public function orderitems()
    {
        return $this->hasMany('OrderItem', 'order_id');
    }

}