<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserAddressesTable extends Migration {

	public function up()
	{
		Schema::create('user_addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('address_l1', 255)->nullable();
			$table->string('address_l2', 255)->nullable();
			$table->integer('country')->nullable();
			$table->string('state', 255)->nullable();
			$table->string('city', 255)->nullable();
			$table->integer('pincode')->nullable();
			$table->boolean('is_primary')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('user_addresses');
	}
}