<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAppsGeokmerTable extends Migration {

	public function up()
	{
		Schema::create('apps_geokmer', function(Blueprint $table) {
			$table->increments('id');
			$table->string('nom');
			$table->string('locale')->default('fr');
			$table->string('icone')->nullable();
			$table->text('desc');
			$table->datetime('date');
			$table->bigInteger('nbre_vues')->nullable()->default('0');
			$table->integer('sous_categories_id')->unsigned()->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('apps_geokmer');
	}
}