<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSuggestionsAppTable extends Migration {

	public function up()
	{
		Schema::create('suggestions_app', function(Blueprint $table) {
			$table->increments('id');
			$table->text('libelle');
			$table->string('locale')->default('fr');
			$table->datetime('date');
			$table->bigInteger('membre_id')->nullable()->default('0');
			$table->integer('app_id')->unsigned()->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('suggestions_app');
	}
}