<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommentairesAppTable extends Migration {

	public function up()
	{
		Schema::create('commentaires_app', function(Blueprint $table) {
			$table->increments('id');
			$table->text('libelle');
			$table->datetime('date');
			$table->string('locale')->default('fr');
			$table->integer('app_id')->unsigned()->default('0');
			$table->bigInteger('membre_id')->unsigned()->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('commentaires_app');
	}
}