<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePointsInteretTable extends Migration {

	public function up()
	{
		Schema::create('points_interet', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->integer('sous_categorie_id')->nullable()->default('0');
			$table->float('latitude')->nullable()->default('0');
			$table->float('longitude')->nullable()->default('0');
			$table->string('nom');
			$table->string('locale')->default('fr');
			$table->integer('arrondissement_id')->nullable()->default('0');
			$table->string('ville');
			$table->string('quartier');
			$table->string('code_postal');
			$table->string('adresse');
			$table->string('site_web');
			$table->string('telephone1');
			$table->string('telephone2');
			$table->bigInteger('membre_id')->nullable()->default('0');
			$table->string('horaire');
			$table->string('bon_plan');
			$table->datetime('date_enregistrement');
			$table->datetime('date_update');
			$table->smallInteger('nbre_points')->nullable()->default('0');
			$table->bigInteger('user_id')->nullable()->default('0');
			$table->bigInteger('nbre_vues')->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('points_interet');
	}
}