<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSuggestionsLieuTable extends Migration {

	public function up()
	{
		Schema::create('suggestions_lieu', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('sous_categorie_id')->nullable()->default('0');
			$table->float('latitude')->nullable()->default('0');
			$table->float('longitude');
			$table->string('lonale')->default('fr');
			$table->string('nom');
			$table->integer('arrondissement_id')->nullable()->default('0');
			$table->string('ville');
			$table->string('quartier');
			$table->string('code_postal');
			$table->string('adresse');
			$table->string('site_web');
			$table->string('telephone1');
			$table->string('telephone2');
			$table->bigInteger('membre_id')->nullable()->default('0');
			$table->string('horaire');
			$table->string('bon_plan');
			$table->datetime('date_enregistrement');
			$table->datetime('date_update');
			$table->smallInteger('nbre_points')->nullable()->default('0');
			$table->text('desc');
			$table->text('autre_infos');
			$table->string('facebook');
			$table->string('twitter');
			$table->string('whatsapp');
			$table->string('pinterest');
			$table->string('instagram');
			$table->string('viadeo');
			$table->string('problem');
			$table->boolean('option');
			$table->bigInteger('nbre_vues')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('suggestions_lieu');
	}
}