<?php

namespace Model;

class PointInteret extends Eloquent {

	protected $table = 'points_interet';
	public $timestamps = false;

	public function commentaires_lieux()
	{
		return $this->hasMany('CommentairesLieu');
	}

	public function notes_lieux()
	{
		return $this->hasMany('NotesLieu');
	}

	public function likes_lieux()
	{
		return $this->hasMany('LikesLieu');
	}

	public function photos_lieux()
	{
		return $this->hasMany('PhotosLieu');
	}

	public function arrondissement()
	{
		return $this->belongsTo('Arrondissement', 'arrondissement_id');
	}

	public function sous_categorie()
	{
		return $this->belongsTo('SousCategorie', 'sous_categorie_id');
	}

	public function sauvegardes_lieux()
	{
		return $this->hasMany('SauvegardeLieu');
	}

	public function visites_lieux()
	{
		return $this->hasMany('VisiteLieu');
	}

	public function details_lieu()
	{
		return $this->hasOne('DetailsLieu');
	}

}