<?php

namespace Model;

use Illuminate\Database\Eloquent\Model;

class Membre extends Model 
{

    protected $table = 'membres';
    public $timestamps = false;

    public function suggestions_apps()
    {
        return $this->hasMany('SuggestionApp');
    }

    public function recherches()
    {
        return $this->hasMany('Recherche');
    }

    public function note_app()
    {
        return $this->hasOne('NoteApp');
    }

    public function like_app()
    {
        return $this->hasOne('LikeApp');
    }

    public function telechargements()
    {
        return $this->hasMany('Telechargement');
    }

    public function commentaires_apps()
    {
        return $this->hasMany('CommentaireApp');
    }

    public function abonnements()
    {
        return $this->belongsToMany('Abonnement', 'mebre_abonnement', 'mebre_id', 'abonnement_id');
    }

    public function commentaires_lieux()
    {
        return $this->hasMany('CommentairesLieu');
    }

    public function note_lieu()
    {
        return $this->hasOne('NotesLieu');
    }

    public function like_lieu()
    {
        return $this->hasOne('LikesLieu');
    }

    public function sauvegardes()
    {
        return $this->hasMany('SauvegardeLieu');
    }

    public function visites_lieux()
    {
        return $this->hasMany('VisiteLieu');
    }

    public function conseils_avis()
    {
        return $this->hasMany('ConseilAvis');
    }

}