<?php

namespace App\Models;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function productCategory()
	{
		return $this->belongsTo('ProductCategory');
	}

	public function orderItems()
	{
		return $this->hasMany('App\Models\OrderItem');
	}

	public function vatCategory()
	{
		return $this->belongsTo('App\Models\VatCategory');
	}

}