<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFixturesTable extends Migration {

	public function up()
	{
		Schema::create('fixtures', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('team_home')->unsigned();
			$table->integer('team_away')->unsigned();
			$table->integer('api_id');
			$table->timestamps();
			$table->char('status', 5);
			$table->integer('league_id')->unsigned();
			$table->integer('round_id')->unsigned();
			$table->boolean('is_live')->default(false);
			$table->smallInteger('goals_home');
			$table->smallInteger('goals_away');
			$table->smallInteger('penalty_home');
			$table->smallInteger('penalty_away');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('fixtures');
	}
}