<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeamsTable extends Migration {

	public function up()
	{
		Schema::create('teams', function(Blueprint $table) {
			$table->increments('id');
			$table->char('name', 120);
			$table->char('slug', 120);
			$table->char('code', 3)->unique();
			$table->integer('country_id')->unsigned();
			$table->boolean('national')->default(false);
			$table->integer('api_id')->unique();
		});
	}

	public function down()
	{
		Schema::drop('teams');
	}
}