<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEstatesTable extends Migration {

	public function up()
	{
		Schema::create('estates', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name_ar');
			$table->string('name_en');
			$table->enum('type', array('commercial', 'residential'));
			$table->enum('status', array('rent', 'unrent'));
			$table->string('sk_number');
			$table->string('address');
			$table->double('manage_ratio');
			$table->longText('notes')->nullable();
			$table->integer('city_id')->unsigned();
			$table->integer('estate_owner_id')->unsigned();
			$table->integer('estate_manager_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('estates');
	}
}