<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('color_fruit', function(Blueprint $table) {
			$table->foreign('color_id')->references('id')->on('colors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('color_fruit', function(Blueprint $table) {
			$table->foreign('fruit_id')->references('id')->on('fruits')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('color_fruit', function(Blueprint $table) {
			$table->dropForeign('color_fruit_color_id_foreign');
		});
		Schema::table('color_fruit', function(Blueprint $table) {
			$table->dropForeign('color_fruit_fruit_id_foreign');
		});
	}
}