<?php

namespace App\Task;

class Task extends Eloquent {

	protected $table = 'Task';
	public $timestamps = true;

	public function language()
	{
		return $this->hasOne('Language');
	}

	public function tests()
	{
		return $this->hasMany('Test');
	}

	public function report()
	{
		return $this->hasOne('Report');
	}

	public function followers()
	{
		return $this->hasMany('TaskFollower');
	}

	public function taskStatus()
	{
		return $this->hasOne('TaskStatus');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function project()
	{
		return $this->belongsTo('Project');
	}

}