<?php

namespace App\User;

class User extends Eloquent {

	protected $table = 'User';
	public $timestamps = true;

	public function projects()
	{
		return $this->hasMany('Project');
	}

	public function member()
	{
		return $this->belongsTo('Member');
	}

	public function userGroup()
	{
		return $this->belongsTo('UserGroup');
	}

	public function userRoles()
	{
		return $this->belongsTo('UserRole');
	}

	public function tasks()
	{
		return $this->hasMany('Task');
	}

}