<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->string('id')->primary();
			$table->string('name');
			$table->string('email')->unique();
			$table->string('password');
			$table->string('phone')->unique();
			$table->enum('phone_verified', array('yes', 'no'));
			$table->enum('email_verified', array('yes', 'no'));
			$table->string('address');
			$table->string('pin_code');
			$table->string('city');
			$table->string('state');
			$table->string('country');
			$table->enum('gender', array('male', 'female', 'other'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}