<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->string('id')->primary();
			$table->string('transaction_id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('transaction_amount');
			$table->string('vendor_id');
			$table->enum('transaction_type', array('bank', 'paytm', 'other'));
			$table->enum('transaction_status', array('pending', 'on_hold', 'in_process', 'completed', ''));
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}