<?php

namespace Dotctor;

use Illuminate\Database\Eloquent\Model;

class Doctor extends Model 
{

    protected $table = 'doctors';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'phone', 'password', 'gender', 'bio', 'image', 'age');

    public function appointments()
    {
        return $this->hasMany('Appointment');
    }

    public function prescriptions()
    {
        return $this->hasMany('Prescription');
    }

    public function medical_tests()
    {
        return $this->hasMany('MedicalTest');
    }

}