<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatientsTable extends Migration {

	public function up()
	{
		Schema::create('patients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191);
			$table->string('email', 191);
			$table->string('phone', 191);
			$table->string('password', 191);
			$table->string('image', 191);
			$table->integer('age');
			$table->string('diagnosis', 191);
			$table->integer('city_id')->unsigned();
			$table->date('last_appointment');
			$table->string('total_payment', 191);
			$table->string('remaining', 191);
		});
	}

	public function down()
	{
		Schema::drop('patients');
	}
}