<?php

namespace Patient;

class Patient extends Eloquent {

	protected $table = 'patients';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'phone', 'password', 'image', 'age', 'diagnosis', 'city_id', 'last_appointment', 'total_payment', 'remaining');

	public function appointments()
	{
		return $this->hasMany('Appointment');
	}

	public function prescriptions()
	{
		return $this->hasMany('Prescription');
	}

	public function medical_tests()
	{
		return $this->hasMany('MedicalTest');
	}

}