<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMedicalTestsTable extends Migration {

	public function up()
	{
		Schema::create('medical_tests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('doctor_id')->unsigned();
			$table->integer('patient_id')->unsigned();
			$table->string('name', 191);
			$table->string('description', 191)->nullable();
			$table->date('request_date');
			$table->enum('status', array(''pending'', ''approved'', ''rejected''));
			$table->string('result', 191);
		});
	}

	public function down()
	{
		Schema::drop('medical_tests');
	}
}