<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctorsTable extends Migration {

	public function up()
	{
		Schema::create('doctors', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191);
			$table->string('email', 191);
			$table->string('phone', 191);
			$table->string('password', 191);
			$table->enum('gender', array(''male'', ''female''));
			$table->string('bio', 191);
			$table->string('image', 191);
			$table->string('age', 191);
		});
	}

	public function down()
	{
		Schema::drop('doctors');
	}
}