<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientesTable extends Migration {

	public function up()
	{
		Schema::create('clientes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('nombre_comercial', 100);
			$table->string('razon_social', 100);
			$table->string('cif', 20)->nullable();
			$table->string('direccion');
			$table->smallInteger('prioridad');
			$table->string('telefono');
			$table->string('email', 100)->nullable();
			$table->string('url', 200)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('clientes');
	}
}