<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEstadosTable extends Migration {

	public function up()
	{
		Schema::create('estados', function(Blueprint $table) {
			$table->increments('id');
			$table->smallInteger('orden')->nullable()->default('0');
			$table->string('nombre');
			$table->string('color', 6)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('estados');
	}
}