<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTareasTable extends Migration {

	public function up()
	{
		Schema::create('tareas', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_proyecto');
			$table->integer('id_estado');
			$table->integer('id_user')->nullable();
			$table->smallInteger('orden')->nullable()->default('0');
			$table->string('nombre');
			$table->tinyInteger('importante')->nullable()->default('0');
			$table->tinyInteger('urgente')->nullable()->default('0');
			$table->smallInteger('porcentaje');
			$table->smallInteger('peso');
			$table->date('fecha_limite')->nullable();
			$table->timestamps();
			$table->timestamp('archived_at')->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('tareas');
	}
}