<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Proyecto extends Model 
{

    protected $table = 'proyectos';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function cliente()
    {
        return $this->belongsTo('App\Proyecto', 'id_cliente');
    }

    public function tareas()
    {
        return $this->hasMany('App\Tarea', 'id_proyecto');
    }

}