<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectDepartmentsTable extends Migration {

	public function up()
	{
		Schema::create('project_departments', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('project_id')->unsigned()->index();
			$table->integer('department_id')->unsigned()->index();
			$table->decimal('percentage', 5,2)->nullable();
			$table->decimal('progress', 5,2)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('project_departments');
	}
}