<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectTasksTable extends Migration {

	public function up()
	{
		Schema::create('project_tasks', function(Blueprint $table) {
			$table->increments('id');
			$table->text('description')->nullable();
			$table->string('origin')->nullable();
			$table->string('unit')->nullable();
			$table->integer('quantity')->nullable()->default('0');
			$table->decimal('usd')->nullable();
			$table->decimal('bdt')->nullable();
			$table->decimal('equivalent_usd')->nullable();
			$table->integer('project_id')->unsigned()->index();
			$table->integer('user_id')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('project_tasks');
	}
}