<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTaskDetailsTable extends Migration {

	public function up()
	{
		Schema::create('task_details', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('project_task_id')->unsigned();
			$table->integer('project_department_id')->unsigned();
			$table->date('starting_date');
			$table->date('ending_date')->nullable();
			$table->decimal('progress', 5,2)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('task_details');
	}
}