<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Destination extends Model 
{

    protected $table = 'destination';
    public $timestamps = true;
    protected $fillable = array('title', 'min_purchase', 'max_purchase', 'price_per_person', 'description', 'tour_status', 'map_lat', 'map_lng');

    public function picts()
    {
        return $this->hasMany('DestinationPict');
    }

    public function city()
    {
        return $this->belongsTo('City');
    }

    public function destination_facilities()
    {
        return $this->hasMany('DestinationFacilities');
    }

    public function reservation()
    {
        return $this->hasMany('Reservation');
    }

}