<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Teacher', function(Blueprint $table) {
			$table->foreign('uid')->references('uid')->on('User')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Student', function(Blueprint $table) {
			$table->foreign('uid')->references('uid')->on('User')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Course', function(Blueprint $table) {
			$table->foreign('tid')->references('tid')->on('Teacher')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Section', function(Blueprint $table) {
			$table->foreign('cid')->references('cid')->on('Course')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Assignment', function(Blueprint $table) {
			$table->foreign('sid')->references('sid')->on('Section')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Announcement', function(Blueprint $table) {
			$table->foreign('sid')->references('sid')->on('Section')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Group', function(Blueprint $table) {
			$table->foreign('cid')->references('cid')->on('Course')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Groups', function(Blueprint $table) {
			$table->foreign('gid')->references('gid')->on('Group')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Groups', function(Blueprint $table) {
			$table->foreign('sid')->references('sid')->on('Section')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Dropbox', function(Blueprint $table) {
			$table->foreign('tid')->references('tid')->on('Teacher')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('AssignmentSubmissions', function(Blueprint $table) {
			$table->foreign('aid')->references('aid')->on('Assignment')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('AssignmentSubmissions', function(Blueprint $table) {
			$table->foreign('sid')->references('sid')->on('Section')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('AssignmentSubmissions', function(Blueprint $table) {
			$table->foreign('stuid')->references('stuid')->on('Student')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('SectionStudents', function(Blueprint $table) {
			$table->foreign('sid')->references('sid')->on('Section')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('SectionStudents', function(Blueprint $table) {
			$table->foreign('stuid')->references('stuid')->on('Student')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('Teacher', function(Blueprint $table) {
			$table->dropForeign('Teacher_uid_foreign');
		});
		Schema::table('Student', function(Blueprint $table) {
			$table->dropForeign('Student_uid_foreign');
		});
		Schema::table('Course', function(Blueprint $table) {
			$table->dropForeign('Course_tid_foreign');
		});
		Schema::table('Section', function(Blueprint $table) {
			$table->dropForeign('Section_cid_foreign');
		});
		Schema::table('Assignment', function(Blueprint $table) {
			$table->dropForeign('Assignment_sid_foreign');
		});
		Schema::table('Announcement', function(Blueprint $table) {
			$table->dropForeign('Announcement_sid_foreign');
		});
		Schema::table('Group', function(Blueprint $table) {
			$table->dropForeign('Group_cid_foreign');
		});
		Schema::table('Groups', function(Blueprint $table) {
			$table->dropForeign('Groups_gid_foreign');
		});
		Schema::table('Groups', function(Blueprint $table) {
			$table->dropForeign('Groups_sid_foreign');
		});
		Schema::table('Dropbox', function(Blueprint $table) {
			$table->dropForeign('Dropbox_tid_foreign');
		});
		Schema::table('AssignmentSubmissions', function(Blueprint $table) {
			$table->dropForeign('AssignmentSubmissions_aid_foreign');
		});
		Schema::table('AssignmentSubmissions', function(Blueprint $table) {
			$table->dropForeign('AssignmentSubmissions_sid_foreign');
		});
		Schema::table('AssignmentSubmissions', function(Blueprint $table) {
			$table->dropForeign('AssignmentSubmissions_stuid_foreign');
		});
		Schema::table('SectionStudents', function(Blueprint $table) {
			$table->dropForeign('SectionStudents_sid_foreign');
		});
		Schema::table('SectionStudents', function(Blueprint $table) {
			$table->dropForeign('SectionStudents_stuid_foreign');
		});
	}
}