<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStockCountsTable extends Migration {

	public function up()
	{
		Schema::create('stock_counts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('reference_no', 191);
			$table->integer('warehouse_id');
			$table->string('category_id', 191);
			$table->string('brand_id', 191);
			$table->integer('user_id');
			$table->string('type', 191);
			$table->string('initial_file', 191);
			$table->string('final_file', 191);
			$table->text('note');
			$table->tinyInteger('is_adjusted');
			$table->timestamps();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('stock_counts');
	}
}