<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('TAXITaxameter', function(Blueprint $table) {
			$table->foreign('TAXIFahrzeugID')->references('id')->on('TAXIFahrzeu')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('TAXIStrafzettel', function(Blueprint $table) {
			$table->foreign('TAXIFahrerID')->references('TAXIFahrerID')->on('TAXIFahrerdetails')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('TAXITaxameter', function(Blueprint $table) {
			$table->dropForeign('TAXITaxameter_TAXIFahrzeugID_foreign');
		});
		Schema::table('TAXIStrafzettel', function(Blueprint $table) {
			$table->dropForeign('TAXIStrafzettel_TAXIFahrerID_foreign');
		});
	}
}