<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Conversacion extends Model 
{

    protected $table = 'conversaciones';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function usuarios()
    {
        return $this->belongsToMany('Usuario');
    }

    public function mensajes()
    {
        return $this->hasMany('Mensaje');
    }

}