<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Conversacion extends Eloquent {

	protected $table = 'conversaciones';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function usuarios()
	{
		return $this->belongsToMany('Usuario');
	}

	public function mensajes()
	{
		return $this->hasMany('Mensaje');
	}

}