<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInstallmentinvoicesTable extends Migration {

	public function up()
	{
		Schema::create('installmentinvoices', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('client_id');
			$table->integer('branch_id');
			$table->double('sell_price');
			$table->double('base_price');
			$table->double('pre_amount');
			$table->double('remain_amount');
			$table->date('start_at');
			$table->integer('count');
			$table->double('amount');
			$table->integer('system');
			$table->double('paid');
			$table->string('note')->nullable();
			$table->integer('user_id');
		});
	}

	public function down()
	{
		Schema::drop('installmentinvoices');
	}
}