<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReturnedTable extends Migration {

	public function up()
	{
		Schema::create('returned', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('branch_id')->nullable();
			$table->integer('invoice_id')->nullable();
			$table->enum('invoice_type', array('cash', 'bill'))->nullable();
			$table->string('account_id')->nullable();
			$table->integer('user_id')->nullable();
			$table->double('total')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('returned');
	}
}