<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Returned extends Model 
{

    protected $table = 'returned';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('branch_id', 'invoice_id', 'invoice_type', 'account_id', 'user_id', 'total');

    public function items()
    {
        return $this->hasMany('ReturnedItems', 'returned_id');
    }

    public function branch()
    {
        return $this->belongsTo('Branches', 'branch_id');
    }

    public function invoice()
    {
        return $this->belongsTo('Invoices', 'invoice_id');
    }

    public function account()
    {
        return $this->belongsTo('Accounts', 'account_id');
    }

    public function user()
    {
        return $this->belongsTo('Users', 'user_id');
    }

}