<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Accounthistories extends Model 
{

    protected $table = 'accounthistories';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('account_id', 'amount', 'note', 'user_id');

    public function account()
    {
        return $this->belongsTo('Accounts', 'account_id');
    }

    public function user()
    {
        return $this->belongsTo('Users', 'user_id');
    }

}