<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Accounthistories extends Eloquent {

	protected $table = 'accounthistories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('account_id', 'amount', 'note', 'user_id');

	public function account()
	{
		return $this->belongsTo('Accounts', 'account_id');
	}

	public function user()
	{
		return $this->belongsTo('Users', 'user_id');
	}

}